<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:html="http://www.w3.org/1999/xhtml"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwtoc wwlinks wwmode wwfiles wwdoc wwsplits wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc"
>

 <xsl:template name="TableOfContents">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamTOC" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamFramesetSplit" />

  <!-- Page Rule -->
  <!--           -->
  <xsl:variable name="VarPageRule" select="wwprojext:GetRule('Page', $ParamSplit/@stylename)" />

  <!-- CSS Path -->
  <!--          -->

  <!-- Split files -->
  <!--             -->
  <xsl:for-each select="$ParamSplits[1]">
   <!-- Generate Frameset? -->
   <!--                    -->
   <xsl:variable name="VarGenerateFrameset" select="wwprojext:GetFormatSetting('frameset-generate', 'false')" />

   <!-- TOC -->
   <!--     -->
   <xsl:variable name="VarTOCSplitFile" select="key('wwsplits-files-by-groupid-type', concat($ParamSplit/@groupID, ':', $ParameterTOCSplitFileType))[1]" />

   <!-- Index -->
   <!--       -->
   <xsl:variable name="VarIndexSplitFile" select="key('wwsplits-files-by-groupid-type', concat($ParamSplit/@groupID, ':', $ParameterIndexSplitFileType))[1]" />

   <!-- Previous -->
   <!--          -->
   <xsl:variable name="VarPossiblePreviousSplits" select="$ParamSplit/preceding-sibling::wwsplits:Split[1]" />
   <xsl:variable name="VarPreviousSplit" select="($VarPossiblePreviousSplits[count($VarPossiblePreviousSplits) = 1] | $VarTOCSplitFile[(count($VarPossiblePreviousSplits) = 0) and (count($ParamSplit | $VarTOCSplitFile) = 2)])" />

   <!-- Next -->
   <!--      -->
   <xsl:variable name="VarPossibleNextSplits" select="$ParamSplit/following-sibling::wwsplits:Split[1]" />
   <xsl:variable name="VarNextSplit" select="($VarPossibleNextSplits[count($VarPossibleNextSplits) = 1] | $VarIndexSplitFile[(count($VarPossibleNextSplits) = 0) and (count($ParamSplit | $VarIndexSplitFile) = 2)])" />

   <!-- Conditions -->
   <!--            -->
   <xsl:variable name="VarInitialConditionsAsXML">
    <!-- document-css -->
    <!--              -->
    <xsl:if test="string-length($VarPageRule/wwproject:Options/wwproject:Option[@Name = 'document-css']/@Value) &gt; 0">
     <wwpage:Condition name="document-css" />
    </xsl:if>

    <!-- navigation-top -->
    <!--                -->
    <xsl:variable name="VarNavigationTopGenerateOption" select="$VarPageRule/wwproject:Options/wwproject:Option[@Name = 'navigation-top-generate']/@Value" />
    <xsl:if test="(($VarNavigationTopGenerateOption = 'true') or (string-length($VarNavigationTopGenerateOption) = 0)) and ($VarGenerateFrameset = 'false')">
     <wwpage:Condition name="navigation-top" />
    </xsl:if>

    <!-- navigation-bottom -->
    <!--                   -->
    <xsl:variable name="VarNavigationBottomGenerateOption" select="$VarPageRule/wwproject:Options/wwproject:Option[@Name = 'navigation-bottom-generate']/@Value" />
    <xsl:if test="($VarNavigationBottomGenerateOption = 'true') and ($VarGenerateFrameset = 'false')">
     <wwpage:Condition name="navigation-bottom" />
    </xsl:if>

    <!-- Generate TOC? -->
    <!--               -->
    <xsl:if test="count($VarTOCSplitFile) = 1">
     <xsl:choose>
      <xsl:when test="count($ParamSplit | $VarTOCSplitFile) = 1">
       <!-- navigation-toc-current -->
       <!--                        -->
       <wwpage:Condition name="navigation-toc-current" />
      </xsl:when>

      <xsl:otherwise>
       <!-- navigation-toc-not-current -->
       <!--                        -->
       <wwpage:Condition name="navigation-toc-not-current" />
      </xsl:otherwise>
     </xsl:choose>
    </xsl:if>

    <!-- navigation-previous-exists -->
    <!--                            -->
    <xsl:if test="count($VarPreviousSplit) = 1">
     <wwpage:Condition name="navigation-previous-exists" />
    </xsl:if>

    <!-- navigation-previous-not-exists -->
    <!--                                -->
    <xsl:if test="count($VarPreviousSplit) = 0">
     <wwpage:Condition name="navigation-previous-not-exists" />
    </xsl:if>

    <!-- navigation-next-exists -->
    <!--                        -->
    <xsl:if test="count($VarNextSplit) = 1">
     <wwpage:Condition name="navigation-next-exists" />
    </xsl:if>

    <!-- navigation-next-not-exists -->
    <!--                            -->
    <xsl:if test="count($VarNextSplit) = 0">
     <wwpage:Condition name="navigation-next-not-exists" />
    </xsl:if>

    <!-- Generate Index? -->
    <!--                 -->
    <xsl:if test="count($VarIndexSplitFile) = 1">
     <xsl:choose>
      <xsl:when test="count($ParamSplit | $VarIndexSplitFile) = 1">
       <!-- navigation-index-current -->
       <!--                        -->
       <wwpage:Condition name="navigation-index-current" />
      </xsl:when>

      <xsl:otherwise>
       <!-- navigation-index-not-current -->
       <!--                        -->
       <wwpage:Condition name="navigation-index-not-current" />
      </xsl:otherwise>
     </xsl:choose>
    </xsl:if>

    <!-- Company Info -->
    <!--              -->
    <xsl:call-template name="CompanyInfo-Conditions">
     <xsl:with-param name="ParamPageRule" select="$VarPageRule" />
    </xsl:call-template>
   </xsl:variable>
   <xsl:variable name="VarInitialConditions" select="msxsl:node-set($VarInitialConditionsAsXML)" />

   <!-- Set header/footer conditions -->
   <!--                              -->
   <xsl:variable name="VarConditionsAsXML">
    <!-- Copy existing as is -->
    <!--                     -->
    <xsl:for-each select="$VarInitialConditions/*">
     <xsl:copy-of select="." />
    </xsl:for-each>

    <xsl:for-each select="$VarInitialConditions[1]">
     <!-- header-exists -->
     <!--               -->
     <xsl:variable name="VarHeaderExists" select="count(key('wwpage-conditions-by-name', 'navigation-top') | key('wwpage-conditions-by-name', 'breadcrumbs-top') | key('wwpage-conditions-by-name', 'company-info-top')) &gt; 0" />
     <xsl:if test="$VarHeaderExists">
      <wwpage:Condition name="header-exists" />
     </xsl:if>

     <!-- footer-exists -->
     <!--               -->
     <xsl:variable name="VarFooterExists" select="count(key('wwpage-conditions-by-name', 'navigation-bottom') | key('wwpage-conditions-by-name', 'breadcrumbs-bottom') | key('wwpage-conditions-by-name', 'company-info-bottom')) &gt; 0" />
     <xsl:if test="$VarFooterExists">
      <wwpage:Condition name="footer-exists" />
     </xsl:if>

     <!-- header-footer-exists -->
     <!--                      -->
     <xsl:choose>
      <xsl:when test="$VarHeaderExists or $VarFooterExists">
       <wwpage:Condition name="header-footer-exists" />
      </xsl:when>

      <xsl:otherwise>
       <wwpage:Condition name="header-footer-not-exists" />
      </xsl:otherwise>
     </xsl:choose>
    </xsl:for-each>
   </xsl:variable>
   <xsl:variable name="VarConditions" select="msxsl:node-set($VarConditionsAsXML)" />

   <!-- Replacements -->
   <!--              -->
   <xsl:variable name="VarReplacementsAsXML">
    <!-- webworks-root -->
    <!--               -->
    <wwpage:Replacement name="webworks-root">
     <xsl:comment>
      <xsl:text>
</xsl:text>
      <xsl:text>        var  WebWorksRootPath = &quot;&quot;;
</xsl:text>
      <xsl:text>      // </xsl:text>
     </xsl:comment>
    </wwpage:Replacement>

    <!-- body-style -->
    <!--            -->
    <wwpage:Replacement name="body-style">
     <xsl:attribute name="value">
      <!-- CSS properties -->
      <!--                -->
      <xsl:variable name="VarCSSPropertiesAsXML">
       <xsl:call-template name="CSS-TranslateProjectProperties">
        <xsl:with-param name="ParamProperties" select="$VarPageRule/wwproject:Properties/wwproject:Property" />
        <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
        <xsl:with-param name="ParamSplits" select="$ParamSplits" />
       </xsl:call-template>
      </xsl:variable>
      <xsl:variable name="VarCSSProperties" select="msxsl:node-set($VarCSSPropertiesAsXML)/wwproject:Property" />

      <xsl:call-template name="CSS-InlineProperties">
       <xsl:with-param name="ParamProperties" select="$VarCSSProperties[string-length(@Value) &gt; 0]" />
      </xsl:call-template>
     </xsl:attribute>
    </wwpage:Replacement>

    <wwpage:Replacement name="title" value="{$ParamSplit/@title}" />
    <wwpage:Replacement name="navigation-toc-title" value="{$VarTOCSplitFile/@title}" />
    <wwpage:Replacement name="navigation-previous-title" value="{$GlobalLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'Previous']/@value}" />
    <wwpage:Replacement name="navigation-next-title" value="{$GlobalLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'Next']/@value}" />
    <wwpage:Replacement name="navigation-index-title" value="{$VarIndexSplitFile/@title}" />

    <wwpage:Replacement name="document-css">
     <xsl:attribute name="value">
      <xsl:call-template name="URI-ResolveProjectFileURI">
       <xsl:with-param name="ParamFromAbsoluteURI" select="$ParamSplit/@path" />
       <xsl:with-param name="ParamSplits" select="$ParamSplits" />
       <xsl:with-param name="ParamURI" select="$VarPageRule/wwproject:Options/wwproject:Option[@Name = 'document-css']/@Value" />
      </xsl:call-template>
     </xsl:attribute>
    </wwpage:Replacement>

    <wwpage:Replacement name="locale" value="{wwprojext:GetFormatSetting('locale', 'en')}" />
    <wwpage:Replacement name="content-type" value="{concat('text/html;charset=', wwprojext:GetFormatSetting('encoding', 'utf-8'))}" />

    <wwpage:Replacement name="navigation-top-style">
     <xsl:attribute name="value">
      <xsl:variable name="VarAlignmentProperty" select="$VarPageRule/wwproject:Properties/wwproject:Property[@Name = 'navigation-top-alignment']/@Value" />
      <xsl:choose>
       <xsl:when test="string-length($VarAlignmentProperty) &gt; 0">
        <xsl:value-of select="concat('text-align: ', $VarAlignmentProperty, ';')" />
       </xsl:when>

       <xsl:otherwise>
        <xsl:value-of select="'text-align: left;'" />
       </xsl:otherwise>
      </xsl:choose>
     </xsl:attribute>
    </wwpage:Replacement>

    <wwpage:Replacement name="navigation-bottom-style">
     <xsl:attribute name="value">
      <xsl:variable name="VarAlignmentProperty" select="$VarPageRule/wwproject:Properties/wwproject:Property[@Name = 'navigation-bottom-alignment']/@Value" />
      <xsl:choose>
       <xsl:when test="string-length($VarAlignmentProperty) &gt; 0">
        <xsl:value-of select="concat('text-align: ', $VarAlignmentProperty, ';')" />
       </xsl:when>

       <xsl:otherwise>
        <xsl:value-of select="'text-align: left;'" />
       </xsl:otherwise>
      </xsl:choose>
     </xsl:attribute>
    </wwpage:Replacement>

    <xsl:if test="count($VarTOCSplitFile) = 1">
     <wwpage:Replacement name="navigation-toc-link" value="{wwuri:GetRelativeTo($VarTOCSplitFile/@path, $ParamSplit/@path)}" />
    </xsl:if>
    <xsl:if test="count($VarPreviousSplit) = 1">
     <wwpage:Replacement name="navigation-previous-link" value="{wwuri:GetRelativeTo($VarPreviousSplit/@path, $ParamSplit/@path)}" />
    </xsl:if>
    <xsl:if test="count($VarNextSplit) = 1">
     <wwpage:Replacement name="navigation-next-link" value="{wwuri:GetRelativeTo($VarNextSplit/@path, $ParamSplit/@path)}" />
    </xsl:if>
    <xsl:if test="count($VarIndexSplitFile) = 1">
     <wwpage:Replacement name="navigation-index-link" value="{wwuri:GetRelativeTo($VarIndexSplitFile/@path, $ParamSplit/@path)}" />
    </xsl:if>

    <!-- Company Info -->
    <!--              -->
    <xsl:call-template name="CompanyInfo-Replacements">
     <xsl:with-param name="ParamPageRule" select="$VarPageRule" />
     <xsl:with-param name="ParamPagePath" select="$ParamSplit/@path" />
     <xsl:with-param name="ParamSplits" select="$ParamSplits" />
    </xsl:call-template>

    <!-- Content -->
    <!--         -->
    <wwpage:Replacement name="content">
     <xsl:call-template name="Content-Content">
      <xsl:with-param name="ParamContent" select="$ParamTOC" />
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
      <xsl:with-param name="ParamFrameset" select="wwprojext:GetFormatSetting('frameset-generate', 'false')" />
     </xsl:call-template>
    </wwpage:Replacement>

    <!-- Frameset Replacements -->
    <!--                       -->
    <xsl:if test="$ParamFramesetSplit != 'none'">
     <wwpage:Replacement name="frameset-toc-filename" value="{wwuri:GetRelativeTo($ParamSplit/@path, $ParamFramesetSplit/@path)}" />
     <wwpage:Replacement name="frameset-first-filename" value="{wwuri:GetRelativeTo($ParamSplits/wwsplits:Splits/wwsplits:Split[1]/@path, $ParamFramesetSplit/@path)}" />
     <wwpage:Replacement name="frameset-toc-name" value="WWTOCFrame" />
     <wwpage:Replacement name="frameset-content-name" value="WWContentFrame" />
    </xsl:if>
   </xsl:variable>
   <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

   <!-- Invoke page template -->
   <!--                      -->
   <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate">
    <xsl:with-param name="ParamOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetGroupName($ParamSplit/@groupID))" />
    <xsl:with-param name="ParamOutputPath" select="$ParamSplit/@path" />
    <xsl:with-param name="ParamConditions" select="$VarConditions" />
    <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
   </xsl:apply-templates>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Content-Content">
  <xsl:param name="ParamContent" />
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamFrameset" />

  <html:h2 class="WebWorks_TOC_Title">
   <xsl:value-of select="$ParamSplit/@title" />
  </html:h2>

  <xsl:call-template name="Entries">
   <xsl:with-param name="ParamParent" select="$ParamContent/wwtoc:TableOfContents" />
   <xsl:with-param name="ParamSplit" select="$ParamSplit" />
   <xsl:with-param name="ParamFrameset" select="$ParamFrameset" />
   <xsl:with-param name="ParamLevel" select="1" />
  </xsl:call-template>
 </xsl:template>


 <xsl:template name="Entries">
  <xsl:param name="ParamParent" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamFrameset" />
  <xsl:param name="ParamLevel" />

  <xsl:variable name="VarSubEntries" select="$ParamParent/wwtoc:Entry" />

  <xsl:for-each select="$VarSubEntries[1]">
   <xsl:for-each select="$VarSubEntries">
    <xsl:variable name="VarEntry" select="." />

    <html:div class="{concat('WebWorks_TOC_Level', $ParamLevel)}">
     <xsl:choose>
      <xsl:when test="string-length($VarEntry/@path) &gt; 0">
       <!-- Get link -->
       <!--          -->
       <xsl:variable name="VarRelativeLinkPath" select="wwuri:GetRelativeTo($VarEntry/@path, $ParamSplit/@path)" />

       <html:a class="WebWorks_TOC_Link">
        <xsl:attribute name="href">
         <xsl:value-of select="$VarRelativeLinkPath" />
         <xsl:if test="$VarEntry/@first != 'true'">
          <xsl:value-of select="concat('#', $VarEntry/@linkid)" />
         </xsl:if>
        </xsl:attribute>

        <!-- Add target if frameset -->
        <!--                        -->
        <xsl:if test="$ParamFrameset != 'false'">
         <xsl:attribute name="target">
          <xsl:value-of select="'WWContentFrame'" />
         </xsl:attribute>
        </xsl:if>

        <xsl:call-template name="Paragraph">
         <xsl:with-param name="ParamParagraph" select="$VarEntry/wwdoc:Paragraph" />
        </xsl:call-template>
       </html:a>
      </xsl:when>

      <xsl:otherwise>
       <xsl:call-template name="Paragraph">
        <xsl:with-param name="ParamParagraph" select="$VarEntry/wwdoc:Paragraph" />
       </xsl:call-template>
      </xsl:otherwise>
     </xsl:choose>
    </html:div>

    <xsl:call-template name="Entries">
     <xsl:with-param name="ParamParent" select="$VarEntry" />
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     <xsl:with-param name="ParamLevel" select="$ParamLevel + 1" />
    </xsl:call-template>
   </xsl:for-each>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Paragraph">
  <xsl:param name="ParamParagraph" />

  <xsl:for-each select="$ParamParagraph/wwdoc:Number/wwdoc:Text | $ParamParagraph/wwdoc:TextRun/wwdoc:Text">
   <xsl:value-of select="wwstring:ReplaceWithExpression(@value, '[\t ]+', ' ')" />
  </xsl:for-each>
 </xsl:template>

</xsl:stylesheet>
